/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.security;

import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWParticipantListCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.security.VWFilteredUsersAndGroupsPanel;
import filenet.vw.toolkit.utils.uicontrols.security.VWTypeAheadPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class VWFilteredParticipantPanel
extends VWFilteredUsersAndGroupsPanel
implements ActionListener {
    protected VWParticipantItem[] m_wflGroupItems = null;
    protected JRadioButton m_wflGroupsRadioButton;
    protected VWTypeAheadPanel m_typeAheadPanel;
    protected String m_availableItemsText;

    public VWFilteredParticipantPanel(Container parentContainer, VWSession vwSession) {
        super(parentContainer, vwSession);
        this.m_nType = 2;
    }

    public void init(VWParticipantItem[] selectedParticipantItems, VWParticipantItem[] wflGroupList, boolean bShowParticipants) {
        try {
            if (wflGroupList != null && wflGroupList.length > 0) {
                this.m_wflGroupItems = new VWParticipantItem[wflGroupList.length];
                System.arraycopy(wflGroupList, 0, this.m_wflGroupItems, 0, wflGroupList.length);
            }
            super.init(selectedParticipantItems);
            this.m_wflGroupsRadioButton.doClick();
            if (!bShowParticipants) {
                this.m_groupsRadioButton.setEnabled(false);
                this.m_usersRadioButton.setEnabled(false);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeReferences() {
        if (this.m_wflGroupsRadioButton != null) {
            this.m_wflGroupsRadioButton.removeActionListener(this);
            this.m_wflGroupsRadioButton = null;
        }
        super.removeReferences();
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource().equals(this.m_wflGroupsRadioButton)) {
                this.updateType(2);
            } else if (event.getSource().equals(this.m_usersRadioButton)) {
                this.updateType(0);
            } else if (event.getSource().equals(this.m_groupsRadioButton)) {
                this.updateType(1);
            } else if (event.getSource().equals(this.m_itemFilterPanel)) {
                switch (this.m_nType) {
                    case 0: {
                        this.updateAvailableList(this.m_itemFilterPanel.getUserParticipantItems());
                        break;
                    }
                    case 1: {
                        this.updateAvailableList(this.m_itemFilterPanel.getGroupParticipantItems());
                    }
                }
            } else if (event.getSource().equals(this.m_typeAheadPanel)) {
                switch (this.m_nType) {
                    case 2: {
                        if (event.getActionCommand().equals("EnterKey")) {
                            this.addSelectedItems();
                            break;
                        }
                        this.handleTypeAheadUpdate(event.getActionCommand());
                    }
                }
            } else {
                super.actionPerformed(event);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(JOptionPane.getFrameForComponent(this.m_parentContainer), ex.getLocalizedMessage(), 1);
        }
    }

    protected JPanel getHeaderPanel() {
        try {
            JPanel headerPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 21;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(3, 3, 0, 2);
            headerPanel.add((Component)new JLabel(VWResource.s_showAvailableColon), gbCons);
            ++gbCons.gridx;
            gbCons.insets = new Insets(0, 3, 0, 0);
            this.m_wflGroupsRadioButton = new JRadioButton(VWResource.s_workflowGroups);
            this.m_wflGroupsRadioButton.setSelected(true);
            this.m_wflGroupsRadioButton.addActionListener(this);
            ButtonGroup filterGroup = new ButtonGroup();
            filterGroup.add(this.m_wflGroupsRadioButton);
            headerPanel.add((Component)this.m_wflGroupsRadioButton, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_wflGroupsRadioButton, this, VWResource.s_workflowGroups, VWResource.s_workflowGroups);
            this.m_wflGroupsRadioButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            ++gbCons.gridx;
            gbCons.insets = new Insets(0, 3, 0, 0);
            this.m_usersRadioButton = new JRadioButton(VWResource.s_Users);
            this.m_usersRadioButton.setSelected(false);
            this.m_usersRadioButton.addActionListener(this);
            filterGroup.add(this.m_usersRadioButton);
            headerPanel.add((Component)this.m_usersRadioButton, gbCons);
            headerPanel.add((Component)this.m_usersRadioButton, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_usersRadioButton, this, VWResource.s_Users, VWResource.s_Users);
            this.m_usersRadioButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_groupsRadioButton = new JRadioButton(VWResource.s_Groups);
            this.m_groupsRadioButton.setSelected(false);
            this.m_groupsRadioButton.addActionListener(this);
            filterGroup.add(this.m_groupsRadioButton);
            headerPanel.add((Component)this.m_groupsRadioButton, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_groupsRadioButton, this, VWResource.s_Users, VWResource.s_Users);
            this.m_groupsRadioButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            return headerPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected JPanel getTypeAheadPanel() {
        try {
            this.m_typeAheadPanel = new VWTypeAheadPanel();
            this.m_typeAheadPanel.addActionListener(this);
            this.m_typeAheadPanel.setVisible(true);
            if (this.m_itemFilterPanel != null) {
                this.m_itemFilterPanel.setVisible(false);
            }
            return this.m_typeAheadPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected void initializeLists(Object[] selectedParticipants) {
        try {
            this.setListCellRenderer(new VWParticipantListCellRenderer());
            if (this.m_typeAheadPanel != null) {
                this.m_typeAheadPanel.resetFilterString();
            }
            if (this.m_nType == 2) {
                this.initializeLists(this.m_wflGroupItems, selectedParticipants, null);
            } else {
                this.initializeLists(null, selectedParticipants, this.m_wflGroupItems);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected Object[] onRemoveItemsAction(Object[] items) {
        for (int i = 0; i < items.length; ++i) {
            if (items[i] != null && items[i] instanceof VWParticipantItem) {
                switch (this.m_nType) {
                    case 0: 
                    case 1: {
                        items[i] = null;
                        break;
                    }
                    case 2: {
                        if (this.m_wflGroupItems != null && ((VWParticipantItem)items[i]).getType() == 2) break;
                        items[i] = null;
                    }
                }
                continue;
            }
            items[i] = null;
        }
        return this.removeNullElementsFromArray(items);
    }

    protected void handleTypeAheadUpdate(String actionCommand) {
        int nSelectedIndex = 0;
        if (actionCommand != null && actionCommand.equals("UpdateInsert")) {
            nSelectedIndex = this.m_availableList.getSelectedIndex();
            if (nSelectedIndex < 0) {
                nSelectedIndex = 0;
            }
        } else if (actionCommand == null || actionCommand.equals("UpdateRemove")) {
            // empty if block
        }
        int nNewSelectedIndex = this.returnFirstGreaterIndex(this.m_availableList, this.m_typeAheadPanel.getFilterString(), nSelectedIndex);
        this.m_availableList.setSelectedIndex(nNewSelectedIndex);
        this.m_availableList.ensureIndexIsVisible(nNewSelectedIndex);
    }

    private void updateType(int nType) {
        try {
            switch (nType) {
                case 2: {
                    this.m_nType = nType;
                    if (this.m_availableItemsText == null) {
                        this.m_availableItemsText = this.m_availableLabel.getText();
                    }
                    this.m_availableLabel.setText(VWResource.s_typeAheadLabel);
                    if (this.m_itemFilterPanel != null) {
                        this.m_itemFilterPanel.setVisible(false);
                    }
                    if (this.m_typeAheadPanel != null) {
                        this.m_typeAheadPanel.resetFilterString();
                        this.m_typeAheadPanel.setVisible(true);
                        this.m_typeAheadPanel.requestFocus();
                    }
                    this.initializeLists(this.getSelectedItems());
                    break;
                }
                case 0: 
                case 1: {
                    if (this.m_typeAheadPanel != null) {
                        this.m_typeAheadPanel.setVisible(false);
                    }
                    if (this.m_nType != nType && this.m_itemFilterPanel != null) {
                        this.m_itemFilterPanel.clear();
                        this.m_itemFilterPanel.setVisible(true);
                        this.m_itemFilterPanel.requestFocus();
                    }
                    this.m_nType = nType;
                    if (this.m_availableItemsText != null) {
                        this.m_availableLabel.setText(this.m_availableItemsText);
                    }
                    this.initializeLists(this.getSelectedItems());
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private Object[] removeNullElementsFromArray(Object[] items) {
        Vector<Object> tempVector = new Vector<Object>();
        Object[] newArray = null;
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) continue;
            tempVector.add(items[i]);
        }
        if (tempVector.size() > 0) {
            newArray = new Object[tempVector.size()];
            tempVector.copyInto(newArray);
        }
        return newArray;
    }
}

